"use strict";

var bubble_game;
var my_bubble;
var my_spikes = [];
function bubble_set() {
    this.canvas = document.createElement("canvas");
    this.initiateCanvas = function () {
        this.canvas.width = (window.innerWidth || document.documentElement.clientWidth || document.body.clientWidth) - 30;
        this.canvas.height = Math.floor(2 * screen.availHeight / 3);
        this.context = this.canvas.getContext("2d");
        document.getElementById("marker").appendChild(this.canvas);

        this.spike_len = 50;
        this.spike_count = 1;
        this.spikes = [
            {"x": -this.spike_len, "y": Math.floor(Math.random() * (this.canvas.height + this.spike_len)) - this.spike_len, "src": document.getElementById("spike0"), "dir": 1},
            {"x": Math.floor(Math.random() * (this.canvas.width + this.spike_len)) - this.spike_len, "y": -this.spike_len, "src": document.getElementById("spike1"), "dir": 4},
            {"x": this.canvas.width, "y": Math.floor(Math.random() * (this.canvas.height + this.spike_len)) - this.spike_len, "src": document.getElementById("spike2"), "dir": 2},
            {"x": Math.floor(Math.random() * (this.canvas.width + this.spike_len)) - this.spike_len, "y": this.canvas.height, "src": document.getElementById("spike3"), "dir": 2},
            {"x": -this.spike_len, "y": Math.floor(Math.random() * (this.canvas.height + this.spike_len)) - this.spike_len, "src": document.getElementById("spike4"), "dir": 3},
            {"x": Math.floor(Math.random() * (this.canvas.width + this.spike_len)) - this.spike_len, "y": -this.spike_len, "src": document.getElementById("spike5"), "dir": 3}
        ];
        this.keep_score = 0;

        window.addEventListener('keydown', keyDownControl);
        window.addEventListener('keyup', keyUpControl);

        document.getElementById("continue_game").disabled = true;
        document.getElementById("pause_game").disabled = true;
        $("#start_game").css("cursor", "pointer");

        this.sendScore = document.getElementById("score");
        this.addVibe = document.getElementById("gameSound");
        this.dieSound = document.getElementById("whoosh");
        this.startSound = document.getElementById("start");
        this.goodbyeSound = document.getElementById("goodbye");
        this.topPerformance = document.getElementById("topPlay");
    };
    this.clear = function () {
        this.context.clearRect(0, 0, this.canvas.width, this.canvas.height);
    };
    this.stop = function () {
        clearInterval(bubble_game.interval);
    };
    this.storeScore = function () {
        var top_score = this.score;
        var top_player = "Anonymous";
        var msg_feed = 'Game Is Over. \n\n You kept the bubble for ' +
                Math.floor(this.score / 60) + ' min(s) : ' + (this.score % 60) + ' sec(s)' +
                '.\n\n\n"Your browser does not support the used technology ' +
                'for saving your scores. \nChange or update it."';
        var incorrectFormat = true;
        this.addVibe.pause();
        if (typeof (Storage) != undefined) {
            top_score = localStorage.top_score;
            top_player = localStorage.top_player;
            msg_feed = 'Game Is Over. \n\n You kept the bubble for ' +
                    Math.floor(this.score / 60) + ' min(s) : ' + (this.score % 60) + ' sec(s)' +
                    '.\n Current top score played is ' + Math.floor(top_score / 60) + ' min(s) : ' +
                    (top_score % 60) + ' sec(s)' + ', by ' + top_player + '.';
            if (top_score == undefined || top_score == null || this.score > Number(top_score)) {
                top_score = this.score;
                msg_feed = "Game Is Over. \n\n You've set a new top score of " +
                        Math.floor(top_score / 60) + ' min(s) : ' + (top_score % 60) + ' sec(s)' + '.';
                while (incorrectFormat) {
                    top_player = prompt("You've set a new high score.\nEnter Your Name:", top_player);
                    if (top_player == null) {
                        var top_player = "Anonymous";
                        break;
                    }
                    top_player = top_player.trim();
                    if (top_player == "" || top_player.length > 16 || top_player == undefined) {
                        alert("You did not enter a cogent name!");
                        continue;
                    }
                    incorrectFormat = false;
                    if (!(/([a-zA-Z\s]+)/.test(top_player))) {
                        incorrectFormat = true;
                        alert(top_player + " does not look like a name. Try again");
                    }
                }
                this.topPerformance.play();
                localStorage.top_player = top_player;
                localStorage.top_score = top_score;
            }
        }
        alert(msg_feed);
    };
}

function spike(index) {
    this.index = index;
    this.pace = 2;
    this.update = function () {
        var ctx = bubble_game.context;
        ctx.drawImage(bubble_game.spikes[this.index].src, bubble_game.spikes[this.index].x, bubble_game.spikes[this.index].y);
    };
    this.changePosition = function () {
        var len = bubble_game.spike_len;
        var sx = bubble_game.spikes[this.index].x;
        var sy = bubble_game.spikes[this.index].y;

        var flow_dir = bubble_game.spikes[this.index].dir;

        switch (flow_dir) {
            case 1:
                sx += this.pace;
                sy -= this.pace;
                if (sx + len >= bubble_game.canvas.width) {
                    flow_dir = 2;
                }
                if (sy <= 0) {
                    flow_dir = 3;
                }
                break;
            case 2:
                sx -= this.pace;
                sy -= this.pace;
                if (sx <= 0) {
                    flow_dir = 1;
                }
                if (sy <= 0) {
                    flow_dir = 4;
                }
                break;
            case 3:
                sx += this.pace;
                sy += this.pace;
                if (sx + len >= bubble_game.canvas.width) {
                    flow_dir = 4;
                }
                if (sy + len >= bubble_game.canvas.height) {
                    flow_dir = 1;
                }
                break;
            case 4:
                sx -= this.pace;
                sy += this.pace;
                if (sx <= 0) {
                    flow_dir = 3;
                }
                if (sy + len >= bubble_game.canvas.height) {
                    flow_dir = 2;
                }
                break;
            default:
                throw "Some error occurred.";
        }

        bubble_game.spikes[this.index].x = sx;
        bubble_game.spikes[this.index].y = sy;
        bubble_game.spikes[this.index].dir = flow_dir;
    };
    this.caught = function () {
        var len = bubble_game.spike_len;
        var sx = bubble_game.spikes[this.index].x;
        var sy = bubble_game.spikes[this.index].y;
        var spike_top = {"x": sx + Math.ceil(len / 2), "y": sy};
        var spike_bottom = {"x": sx + Math.ceil(len / 2), "y": sy + len};
        var spike_right = {"x": sx + len, "y": sy + Math.ceil(len / 2)};
        var spike_left = {"x": sx, "y": sy + Math.ceil(len / 2)};

        // determinants for each side of the spike
        var a = my_bubble.x;
        var b = my_bubble.y;
        var r = my_bubble.radius;
        var bub_left = a - r;
        var bub_right = a + r;
        var bub_top = b - r;
        var bub_bottom = b + r;

        if (
                //check contact for top of spike
                        (spike_top.y <= b + Math.sqrt(Math.pow(r, 2) - Math.pow((spike_top.x - a), 2))
                                && spike_bottom.y >= b + Math.sqrt(Math.pow(r, 2) - Math.pow((spike_top.x - a), 2))
                                && spike_top.x >= bub_left && spike_top.x <= bub_right)
                        //check contact for bottom of spike
                        || (spike_bottom.y >= b - Math.sqrt(Math.pow(r, 2) - Math.pow((spike_bottom.x - a), 2))
                                && spike_top.y <= b - Math.sqrt(Math.pow(r, 2) - Math.pow((spike_bottom.x - a), 2))
                                && spike_bottom.x >= bub_left && spike_bottom.x <= bub_right)
                        //check contact for right end of spike
                        || (spike_right.x >= a - Math.sqrt(Math.pow(r, 2) - Math.pow((spike_right.y - b), 2))
                                && spike_left.x <= a - Math.sqrt(Math.pow(r, 2) - Math.pow((spike_right.y - b), 2))
                                && spike_right.y > bub_top && spike_right.y <= bub_bottom)
                        //check contact for left end of spike
                        || (spike_left.x <= a + Math.sqrt(Math.pow(r, 2) - Math.pow((spike_left.y - b), 2))
                                && spike_right.x >= a + Math.sqrt(Math.pow(r, 2) - Math.pow((spike_left.y - b), 2))
                                && spike_left.y >= bub_top && spike_left.y <= bub_bottom)
                        ) {
            return true;
        }
        return false;
    };
}

function keyDownControl(e) {
    bubble_game.keys = (bubble_game.keys || []);
    bubble_game.keys[e.keyCode] = true;
    stopBubbleMotion();
    if (bubble_game.keys && (bubble_game.keys[39] || bubble_game.keys[102])) {
        goRight();
    }
    if (bubble_game.keys && (bubble_game.keys[38] || bubble_game.keys[104])) {
        goUp();
    }
    if (bubble_game.keys && (bubble_game.keys[40] || bubble_game.keys[98])) {
        goDown();
    }
    if (bubble_game.keys && (bubble_game.keys[37] || bubble_game.keys[100])) {
        goLeft();
    }
}

function keyUpControl(e) {
    bubble_game.keys[e.keyCode] = false;
    stopBubbleMotion();
}

/* Track movement of bubble and redraw appropriately. */
function goRight() {
    my_bubble.pace_x = my_bubble.rate;
}

function goDown() {
    my_bubble.pace_y = my_bubble.rate;
}

function goLeft() {
    my_bubble.pace_x = -my_bubble.rate;
}

function goUp() {
    my_bubble.pace_y = -my_bubble.rate;
}

function stopBubbleMotion() {
    my_bubble.pace_x = 0;
    my_bubble.pace_y = 0;
}

/*
 * draw bubble
 */
function bubble(radius, outline_colour, fill_colour, x, y) {
    this.radius = radius;
    this.x = x;
    this.y = y;
    this.rate = 5;
    this.pace_x = 0;
    this.pace_y = 0;
    this.rad2_3 = 2 * Math.round(this.radius / 3);
    this.rad1_2 = Math.round(this.radius / 2);
    this.glit_span = this.rad2_3 - this.rad1_2;
    this.update = function () {
        var ctx = bubble_game.context;

        ctx.fillStyle = "rgba(192, 192, 192, 0.5)";
        ctx.beginPath();
        ctx.arc(this.x, this.y, this.radius, 0, 2 * Math.PI);
        ctx.fill();

        ctx.fillStyle = fill_colour;
        ctx.beginPath();
        ctx.arc(this.x - this.rad2_3, this.y - this.rad2_3, this.rad1_2, 0, Math.PI / 2);
        ctx.arc(this.x - this.glit_span, this.y - this.glit_span, this.rad1_2, Math.PI, 3 * Math.PI / 2);
        ctx.fill();

        ctx.lineWidth = 2;
        ctx.strokeStyle = outline_colour;
        ctx.beginPath();
        ctx.arc(this.x, this.y, this.radius, 0, 2 * Math.PI);
        ctx.stroke();
    };
    this.changePosition = function () {
        if ((this.pace_x == this.rate && this.x + this.radius < bubble_game.canvas.width - this.rate) ||
                (this.pace_x == -this.rate && this.x - this.radius > this.rate)) {
            this.x += this.pace_x;
        }
        if ((this.pace_y == this.rate && this.y + this.radius < bubble_game.canvas.height - this.rate) ||
                (this.pace_y == -this.rate && this.y - this.radius > this.rate)) {
            this.y += this.pace_y;
        }
    };
}

function updateBubbleGame() {
    for (var i = 0; i < bubble_game.spike_count; i++) {
        if (my_spikes[i].caught()) {
            bubble_game.addVibe.pause();
            bubble_game.stop();
            bubble_game.dieSound.play();
            bubble_game.storeScore();

            document.getElementById("start_game").disabled = false;
            bubble_game.keep_score = 0;

            document.getElementById("continue_game").disabled = true;
            document.getElementById("pause_game").disabled = true;
            $("#continue_game").css("cursor", "not-allowed");
            $("#pause_game").css("cursor", "not-allowed");
            var repeat = window.confirm(" Do you want to play again?");
            if (repeat == true) {
                document.getElementById("start_game").disabled = false;
                $("#start_game").css("cursor", "pointer");
                bubble_game.sendScore.innerHTML = "0 min(s) : 0 sec(s)";
                // recreate the canvas
                document.getElementById("marker").removeChild(bubble_game.canvas);
                gameOutset();
            } else {
                document.getElementById("start_game").disabled = true;
                $("#start_game").css("cursor", "not-allowed");
            }
            return;
        }
    }

    bubble_game.score = Math.round(((new Date()).getTime() - bubble_game.start_time) / 1000);
    bubble_game.score += bubble_game.keep_score;

    bubble_game.clear();
    if (bubble_game.score > 240) {
        bubble_game.spike_count = 6;
    } else if (bubble_game.score > 120) {
        bubble_game.spike_count = 5;
    } else if (bubble_game.score > 60) {
        bubble_game.spike_count = 4;
    } else if (bubble_game.score > 30) {
        bubble_game.spike_count = 3;
    } else if (bubble_game.score > 15) {
        bubble_game.spike_count = 2;
    }

    bubble_game.sendScore.innerHTML = Math.floor(bubble_game.score / 60) + " min(s) : " + (bubble_game.score % 60) + " sec(s)";
    for (var i = 0; i < bubble_game.spike_count; i++) {
        my_spikes[i].changePosition();
        my_spikes[i].update();
    }
    my_bubble.changePosition();
    my_bubble.update();
}

function continueGame() {
    bubble_game.start_time = (new Date()).getTime();
    bubble_game.addVibe.play();
    document.getElementById("pause_game").disabled = false;
    document.getElementById("continue_game").disabled = true;
    $("#pause_game").css("cursor", "pointer");
    $("#continue_game").css("cursor", "not-allowed");
    $("#focusable").focus();

    bubble_game.interval = setInterval(updateBubbleGame, 20);
}

function pauseGame() {
    bubble_game.keep_score += Math.round(((new Date()).getTime() - bubble_game.start_time) / 1000);
    bubble_game.addVibe.pause();
    bubble_game.stop();
    document.getElementById("continue_game").disabled = false;
    document.getElementById("pause_game").disabled = true;
    $("#continue_game").css("cursor", "pointer");
    $("#pause_game").css("cursor", "not-allowed");
}

function getStarted() {
    bubble_game.start_time = (new Date()).getTime();

    bubble_game.startSound.play();
    bubble_game.addVibe.play();

    document.getElementById("start_game").disabled = true;
    document.getElementById("continue_game").disabled = true;
    document.getElementById("pause_game").disabled = false;
    $("#start_game").css("cursor", "not-allowed");
    $("#pause_game").css("cursor", "pointer");
    $("#focusable").focus();

    bubble_game.interval = setInterval(updateBubbleGame, 20);
}

function gameOutset() {
    bubble_game = new bubble_set();
    bubble_game.initiateCanvas();
    var bub_radius = Math.round(bubble_game.canvas.width / 12);
    my_bubble = new bubble(bub_radius, "#ff0000", "rgba(255, 255, 255, 0.5)", bubble_game.canvas.width / 2, bubble_game.canvas.height / 2);
    my_spikes = [new spike(0), new spike(1), new spike(2), new spike(3), new spike(4), new spike(5)];
    my_bubble.update();
}